//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

function portInit(%port)
{
   %failCount = 0;
   while(%failCount < 10 && !setNetPort(%port)) {
      echo("Port init failed on port " @ %port @ " trying next port.");
      %port++; %failCount++;
   }
}
 
function createServer(%serverType)
{
   $missionSequence = 0;
   $Server::PlayerCount = 0;
   $Server::ServerType = %serverType;

   // Setup for multi-player, the network must have been
   // initialized before now.
   if (%serverType $= "MultiPlayer") {
      echo("Starting multiplayer mode");

      // Make sure the network port is set to the correct pref.
      portInit($Pref::Server::Port);
      allowConnections(true);

      if ($pref::Net::DisplayOnMaster !$= "Never" )
         schedule(0,0,startHeartbeat);
   }

   // Load the mission
   $ServerGroup = new SimGroup(ServerGroup);
   onServerCreated();
   
   // pre-mission script files that need to be executed
   // (needed when mission loading is dependent on existing functionality)
   // (For example, shadows are created when mission objects are created,
   // so the shadows need to be available before the objects are created)
   exec("~/server/dropShadows.cs");

   // when the server is created, the menu mision should be used
   // since the server is only created during the splash screens
   loadMenuMission($LoadState);
}


//-----------------------------------------------------------------------------


function destroyServer()
{
   $Server::ServerType = "";
   allowConnections(false);
   stopHeartbeat();
   $missionRunning = false;
   
   // this will remove any objects' footprints that have been placed
   // on the terrain and not yet removed
   removeGroupObjects(MissionGroup);
   removeGroupObjects(MissionCleanup);
   removeGroupObjects($ServerGroup);
   
   // clear any selected objects that have been created through
   // the portrait camera
   if(isObject(PortraitCamera)) {
      %component = PortraitCamera.getCameraCmp();
      if(isObject(%component)) {
         %component.setTarget(0);
      }
   }
   
   // Delete the connection if it's still there.
   if(isObject(ServerConnection)) {
      ServerConnection.delete();
   }
   
   // Terminate all playing sounds
   alxStopAll();
   
   // Dump anything we're not using
   clearTextureHolds();
   purgeResources();
   
   // End any running mission
   endMission();
   onServerDestroyed();

   // Delete all the server objects
   if(isObject(MissionGroup)) {
      MissionGroup.delete();
   }
   if(isObject(MissionCleanup)) {
      MissionCleanup.delete();
   }
   if(isObject($ServerGroup)) {
      $ServerGroup.delete();
   }

   // Delete all the connections:
   while(ClientGroup.getCount()) {
      %client = ClientGroup.getObject(0);
      %client.delete();
   }

   $Server::GuidList = "";

   // Delete all the data blocks...
   deleteDataBlocks();
}


//--------------------------------------------------------------------------

function resetServerDefaults()
{
   echo( "Resetting server defaults..." );
   
   // Override server defaults with prefs:   
   exec( "~/defaults.cs" );
   //exec( "~/prefs.cs" );
   exec( $ServerPrefSaveFile );

   loadMission( $Server::MissionFile );
}


//------------------------------------------------------------------------------
// Guid list maintenance functions:
function addToServerGuidList( %guid )
{
   %count = getFieldCount( $Server::GuidList );
   for ( %i = 0; %i < %count; %i++ )
   {
      if ( getField( $Server::GuidList, %i ) == %guid )
         return;
   }

   $Server::GuidList = $Server::GuidList $= "" ? %guid : $Server::GuidList TAB %guid;
}

function removeFromServerGuidList( %guid )
{
   %count = getFieldCount( $Server::GuidList );
   for ( %i = 0; %i < %count; %i++ )
   {
      if ( getField( $Server::GuidList, %i ) == %guid )
      {
         $Server::GuidList = removeField( $Server::GuidList, %i );
         return;
      }
   }

   // Huh, didn't find it.
}


//-----------------------------------------------------------------------------

function onServerInfoQuery()
{
   // When the server is queried for information, the value
   // of this function is returned as the status field of
   // the query packet.  This information is accessible as
   // the ServerInfo::State variable.
   return "Doing Ok";
}

